function [alpha, beta, gamma] = dir2cos(azi, dip)
% DIR2COS Convert a geographic direction to a unit vector direction
%   [alpha, beta, gamma] = dir2cos(azi, dip) 
%   dir2cos takes a geographic direction specified by its azimuth (azi) and
%   its dip (or plunge), and converts it to a unit vector, specified by
%   alpha beta, gamma. The geographic convention that north is 0 or 360
%   degrees is used.
% 
%   Yannick Kremer 2006
%   
%   See also COS2DIR

    d2r = 180/pi;
    alpha = sin( azi./d2r ) .* cos( dip./d2r );
    beta =  cos( azi./d2r ) .* cos( dip./d2r );
    gamma = sin( dip./d2r);
end